#include <bits/stdc++.h>
using namespace std;

typedef long long ll;

ll bit_remove_tz(ll x) {
	return x >> __builtin_ctzll(x);
}

ll bit_gcd(ll x, ll y) { // x, y su neparni ili 0
	if (!x) return y;
	if (!y) return x;
	while (1) {
		x = bit_remove_tz(x);
		y = bit_remove_tz(y);
		if (x == y)
			return x;
		auto a = __builtin_clzll(x);
		auto b = __builtin_clzll(y);
		ll t = x;
		x = (x << max(a-b, 0)) ^ y;
		y = t;
	}
}

const int MAXN = 131072;
ll a[2 * MAXN];

ll solve(int l, int r, int x, int xl, int xr) {
	if (r < xl || xr < l)
		return 0;
	if (l <= xl && xr <= r)
		return a[x];
	int xm = (xl + xr) >> 1;
	return bit_gcd(solve(l, r, 2*x, xl, xm), solve(l, r, 2*x+1, xm+1, xr));
}

void change(int p, ll x) {
	p += MAXN;
	a[p] = x;
	while (p > 1) {
		p >>= 1;
		a[p] = bit_gcd(a[2*p], a[2*p+1]);
	}
}

int main() {
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);

	int n;
	cin >> n;
	for (int i=1; i<=n; i++) {
		ll x;
		cin >> x;
		change(i, bit_remove_tz(x));
	}

	int q;
	cin >> q;
	while (q--) {
		int t;
		cin >> t;
		if (t == 2) {
			int l, r;
			cin >> l >> r;
			cout << solve(l, r, 1, 0, MAXN-1) << '\n';
		} else {
			int p;
			ll x;
			cin >> p >> x;
			change(p, bit_remove_tz(x));
		}
	}
}